
TCC_MOVE_UP							= 1       //ptz up
TCC_MOVE_UP_STOP					= 2       //stop ptz up
TCC_MOVE_DOWN						= 3       //ptz down
TCC_MOVE_DOWN_STOP					= 4       //stop ptz down
TCC_MOVE_LEFT						= 5       //ptz left
TCC_MOVE_LEFT_STOP					= 6       //stop ptz left
TCC_MOVE_RIGHT						= 7       //ptz right
TCC_MOVE_RIGHT_STOP					= 8       //stop ptz right
TCC_MOVE_UP_LEFT					= 9       //ptz top left
TCC_MOVE_UP_LEFT_STOP				= 10      //stop ptz top left
TCC_MOVE_UP_RIGHT					= 11      //ptz top right
TCC_MOVE_UP_RIGHT_STOP				= 12      //stop ptz top right
TCC_MOVE_DOWN_LEFT					= 13      //ptz down left
TCC_MOVE_DOWN_LEFT_STOP				= 14      //stop ptz down left
TCC_MOVE_DOWN_RIGHT					= 15      //ptz down right
TCC_MOVE_DOWN_RIGHT_STOP			= 16      //stop ptz down right
TCC_HOR_AUTO						= 21      //horizontal auto        
TCC_HOR_AUTO_STOP					= 22	  //stop horizontal auto
TCC_HOR_AUTO						= 21      //horizontal auto        
TCC_HOR_AUTO_STOP					= 22		//stop horizontal auto
TCC_ZOOM_BIG						= 31      //zoom big
TCC_ZOOM_BIG_STOP					= 32      //stop zoom big
TCC_ZOOM_SMALL						= 33      //zoom small
TCC_ZOOM_SMALL_STOP					= 34      //stop zoom small
TCC_FOCUS_FAR						= 35      //focus far
TCC_FOCUS_FAR_STOP					= 36      //stop focus far
TCC_FOCUS_NEAR						= 37      //focus near
TCC_FOCUS_NEAR_STOP					= 38      //stop focus near
TCC_IRIS_OPEN						= 39      //open iris 
TCC_IRIS_OPEN_STOP					= 40      //stop open iris
TCC_IRIS_CLOSE						= 41      //close iris
TCC_IRIS_CLOSE_STOP					= 42      //stop close iris
TCC_CALL_VIEW						= 62      //call camera
TCC_SET_VIEW						= 63      //set preset
TCC_DELETE_VIEW						= 64      //delete preset

PROTOCOL_MOVE_UP              		= 1        //move up        
PROTOCOL_MOVE_DOWN              	= 2        //move down      
PROTOCOL_MOVE_LEFT              	= 3        //move left      
PROTOCOL_MOVE_RIGHT             	= 4        //move right     
PROTOCOL_MOVE_UP_RIGHT          	= 5        //move up_right  
PROTOCOL_MOVE_UP_LEFT           	= 6        //move up_left   
PROTOCOL_MOVE_DOWN_RIGHT        	= 7        //move down_right
PROTOCOL_MOVE_DOWN_LEFT         	= 8        //move down_left 
PROTOCOL_MOVE_STOP              	= 9        //stop move    
PROTOCOL_ZOOMIN                 	= 10       //magnify
PROTOCOL_ZOOMOUT                	= 11       //lessen
PROTOCOL_IST						= 12		//stop change
PROTOCOL_FOCUS_ON					= 13		//focus near
PROTOCOL_FOCUS_OFF					= 14		//focus far
PROTOCOL_PTZ_FST		 			= 15		//stop focus change
PROTOCOL_IRIS_OPEN					= 17 	    //aperture bigger
PROTOCOL_IRIS_CLOSE			   		= 18		//aperture samller
PROTOCOL_AUTO_SCAN_START			= 23		//start scanning
PROTOCOL_AUTO_SCAN_STOP				= 24		//stop scaning
PROTOCOL_PRESET						= 25		//run to the preset sp
PROTOCOL_SET_PRESET		 			= 28       //set preset spot
PROTOCOL_DELETE_PRESET				= 37		//delete preset spot

SET_HOR_AUTO_BEGIN					= 23		//set  horizontal auto start
SET_HOR_AUTO_END					= 24      //set  horizontal auto end

OSDTYPE_TIME    					= 1		 	//字符叠加日期时间的宏值
OSDTYPE_TITLE						= 2		 	//字符叠加标题的宏值
OSD_CHANNELTITLE  					= 1		 	//字符叠加标题类型
OSD_DATETIME						= 2		 	//字符叠加日期时间类型

LOCAL_PRE_REC_PATH					= 0  		//视频预览录像路径
LOCAL_PRE_CAP_PATH					= 1  		//视频预览抓拍路径
LOCAL_PBK_REC_PATH					= 2  		//录像回放剪切路径
LOCAL_PBK_CAP_PATH					= 3  		//录像回放抓拍路径
LOCAL_DNL_FILE_PATH					= 4  		//录像下载路径
LOCAL_VCA_CAP_PATH					= 5  		//智能分析抓拍路径
LOCAL_DELAY_MODE					= 6  		//播放性能
LOCAL_PROTOCAL_TYPE					= 7  		//协议类型
LOCAL_CAPTURE_TYPE					= 8  		//抓拍图片类型
LOCAL_DOWNLOAD_TYPE					= 9	 		//录像下载类型

//回放相关命令值
Query_Cmd							= 0x00090000	//查询录像文件
Query_QueryEx_Cmd					= 0x00090001	//查询录像文件，可按码流查询
StartPlayBackByTime_Cmd				= 0x00020065	//按时间段回放远程录像文件

H264B								=0		//H264B编码类型
H264M								=1		//H264M编码类型
H264H								=2		//H264H编码类型
MJPEG								=3		//MJPEG编码类型
MPEG4								=4		//MPEG4编码类型
H265								=5 		//H265编码类型

 //本地录像文件类型*************************************************************
LOCAL_FILE_TYPE_DEFAULT	= 0
LOCAL_FILE_TYPE_PS  	= 1
LOCAL_FILE_TYPE_SDV		= 2
LOCAL_FILE_TYPE_MP4		= 3
LOCAL_FILE_TYPE_AVI		= 4

/* swallow插件命令值映射文件
* swallow_on_init => 播放窗体以及配置文件初始化命令值
* swallow_live => swallow预览功能命令值
* swallow_play_back => swallow回放功能命令值
*/
var swallow_json = {
    'swallow_on_init': {
        'Init_Cmd': 0x00020052, // 插件初始化
        'Login_Cmd': 0x00010000, // 登录设备连接
		'Entry_WorkMode': 0x0001000C, // swallow登录模式 0同步 1异步
		'Login_Off': 0x00010001, // 注销设备连接
		'Reboot_Dev': 0x00000004, //重启设备
        'FullScreen_Cmd': 0x00000006, // 设置系统多画面全屏显示
        'Monopolize_Cmd': 0x00020014, // 设置视频窗口个数
        'LocalConfigInfo_Set': 0x0000000e, // 设置本地配置信息
        'LocalConfigInfo_Get': 0x0000000f, // 获取本地配置信息
        'SelectFileFolder': 0x00000011, // 选择文件夹
        'SelectFilePath': 0x00000010, // 选择文件播放
        'OpenLocFileCmd': 0x00020109, // 打开本地保存的图片文件
		'SetDigitalChannelConfig': 0x00070027, //设置数字通道参数
		'GetDigitalChannelConfig': 0x00070028, //获取数字通道参数
		'SetOsdType': 0x00060000,	//设置字符叠加类型
		'GetOsdType': 0x00060001,	//获取字符叠加类型
		'SetOsdText': 0x00060002,	//设置字符叠加内容
		'GetOsdText': 0x00060003,	//获取字符叠加内容
		'GetOsdDateFormat':0x00060009,	//获取日期时间格式
		'SetOsdDateFormat': 0x0006000c,	//设置日期时间格式
		'SetOsdAdditional': 0x0006000e,	//设置附加字符
		'GetOsdAdditional':	0x0006000f,	//获取附加字符
		'SetOsdTypeColor' : 0x00060010,	//设置叠加字符类型颜色
		'GetOsdTypeColor' : 0x00060011,	//获取叠加字符类型颜色
		'SetOsdFontSize': 0x0006000a,	//设置叠加字符字体大小
		'GetOsdFontSize': 0x0006000b,	//获取叠加字符字体大小
		'SetFrameRate' : 0x00070003,	//设置帧率
		'GetFrameRate' : 0x00070004,	//获取帧率
		'SetMaxKByteRate' :	0x00070009,	//设置码率
		'GetMaxKByteRate' :	0x0007000a,	//获取码率
		'SetVideoSize' : 0x0007000b,	//设置分辨率
		'GetVideoSize' : 0x0007000c,	//获取分辨率
		'SetIFrameRate' : 0x0007001b,	//设置I帧帧率
		'GetIFrameRate' : 0x0007001c,	//获取I帧帧率
		'SetEncodeProfile' : 0x00070036,	//设置扩展编码
		'GetEncodeProfile' : 0x00070037,	//获取扩展编码
		'GetEncodeList' : 0x00070038,	//获得编码列表
		'SetVencTypeEx' : 0x00070039,	//设置编码类型	
		'GetVencTypeEx' : 0x0007003a,	//获取编码类型	
		'GetVideoSzList' : 0x0007003b,	//获取视频分辨率列表
		'SetChannelProperty' : 0x00070025,	//设置通道类型
		'GetChannelProperty' : 0x00070026,	//获取通道类型
		'GetFrameList' : 0x0007003c,	//获取视频帧率列表
		'GetFactoryID' : 0x00030012,	//Get Factory ID
		'GetVersionInfo' : 0x00030025,	//Get Version Information
		'SetNVSAddr' : 0x000b0000,		//Set NVS Addr
		'GetNVSAddr' : 0x000b0001,		//Get NVS Addr
		'SetDevName' : 0x00032014,		//Set Device Name
		'GetDevName' : 0x00032015,		//Get Device Name
		'SetDevMode' : 0x00032016,		//Set Device Mode
		'GetDevMode' : 0x00032017,		//Get Device Mode
    },
    'swallow_live': {
        'StartRealTime_Cmd': 0x00020004, // 连接视频
        'Stop_Cmd': 0x00020009, // 断开视频连接(含回放)
        'PreviewStatus_Get': 0x00020054, // 获取视频连接状态
        'TalkEnable_Set': 0x00030037, // 前端对讲
        'MicEnable_Set': 0x0002000b, // 打开和关闭对讲
        'TalkStatus_Get': 0x00020055, // 获取对讲状态
        'VideoShowMode_Set': 0x00020057, // 设置视频显示模式
        'VideoShowMode_Get': 0x00020058, // 获取视频显示模式
        'EZoomEnable_Set': 0x00020028, // 设置电子放大开启和关闭(1-打开 0-关闭)
        'EZoomEnable_Get': 0x00020029, // 获取电子放大状态(1-打开 0-关闭)
        'BeginRec_Cmd': 0x0002000e, // 开始录像
        'EndRec_Cmd': 0x0002000f, // 结束录像
        'RecStatus_Get': 0x00020053, // 获取录像状态
        'Capture_Cmd': 0x0002000d, // 视频截图
        'SpeakerEnable_Set': 0x0002000c, // 音频开关
        'Volume_Set': 0x00020012, // 设置音量大小
        'Volume_Get': 0x00020013, // 获取音量大小
        'ClickedPositon_Get': 0x00020066, // 获取鼠标点击坐标
        'StartDraw_Cmd': 0x00020067, // 开始视频画线
        'StopDraw_Cmd': 0x00020068, // 停止视频画线
        'DrawColor_Cmd': 0x00020069, // 设置画线颜色
        'ClearDraw_Cmd': 0x00020070, // 清除画线
        'GetDraw_Cmd': 0x00020071, // 获取画线
        'SetDraw_Cmd': 0x00020072, // 设置画线
        'LocateEnable_Set': 0x00020016, // 3D定位开启和关闭(1-打开 0-关闭)
        'LocateEnable_Get': 0x00020017, // 获取3D定位功能状态(1-打开 0-关闭)
        'Decrypt_SET': 0x00140000, // 预览视频解密密码
		'ShowBitrate_Set': 0x00020059, //是否在视频画面上叠加显示帧率码率(1-显示 0-隐藏)
        'OcxVersion_check': 0x00000012, //目的插件版本号验证
		'Dev_ChannelCount_Get': 0x00030010,	//获得通道个数
		'Dev_PTZ_Control':	0x00030004,	//透明通道PTZ球机控制
		'Dev_Device_Ctrl': 0x00030006,	//协议模式Ptz球机控制
    },
    'swallow_play_back': {
        'StartPlayBack_Cmd': 0x00020005, // 开始回放本地录像文件，以远程按文件回放
        
        'PlayBackPause_Cmd': 0x00020022, // 回放暂停播放
        'FastForward_Cmd': 0x00020007, // 快进
        'SlowForward_Cmd': 0x00020008, // 慢进
        'StepForward_Cmd': 0x00020063, // 步进
        'PlayStatus_Get': 0x00020073, // 获取回放状态
        'RecStatus_Get': 0x00020053, // 获取录像状态
        'Progress_Set': 0x00020027, // 设置播放进度
        'Progress_Get': 0x00020010, // 获取播放进度
        'PlayBackTotalTime_Get': 0x00020023, // 获取播放总时间
        'PlayBackCurTime_Get': 0x00020025, // 获取当前播放时间
        'DLStart_Cmd': 0x000a0011, // 开始下载文件到本地
        'DLStop_Cmd': 0x000a0012, // 停止下载
        'DLProgress_Get': 0x000a0013, // 获取下载进度
		'Obs_PlayBackSeek_Cmd':	0x00020021, //回放定位
        'Store_LocalEdit_Cmd': 0x000a0022, // 本地剪辑按照帧号
        'Store_LocalEditPos_Get': 0x000a0023, // 获取本地剪辑进度
        'LocalPlayingFrameNum_Get': 0x00020103, // 获取当前视频帧号
        'Store_RemoteEditStart_Cmd': 0x000a0024, // 远程剪辑
        'Store_RemoteEditStop_Cmd': 0x000a0025, // 远程剪辑停止
        'Store_RemoteEditGetPos_Get': 0x000a0026, // 获取远程剪辑进度
        'LocalPlayingFrameNum_Max_Get': 0x00020040, // 获取视频最大帧
        'Alarm_StartPicStream': 0x00040033, // 开启图片流
        'StopPicStream': 0x00040034, //关闭图片流
		'DLStartByTime_Cmd': 0x000a0021, //按时间段下载
    }
}

var NT = {
	'type': swallow_json,
	'pluginVer': "6.1.19.428"
};
(function(NT){
	//视频基类
	var _Video = (function() {
		//分屏窗口信息
		var _ObsInfo = (function() {
			function _ObsInfo(id) {
				this.id = id; //唯一标识
				this.obsId = 0; //_VActiveX：ObsID，_VFlash：VideoId
				this.channelNo = 0; //通道号，从1开始
				this.streamNo = 0; //码流号，从0开始
				this.playState = 0; //播放状态：0-停止，1-播放，2-暂停，3-快进，4-慢放，5-步进，6-快退
				this.viewState = 0; //显示状态: 0-隐藏，1-显示，2-全屏，3-被全屏遮盖，4-被非全屏遮盖
				this.videoMode = 0; //显示方式：0-适应窗口，1-固定比例
				this.isUsed = false; //是否被使用
				this.isTalk = false; //是否正在对讲
				this.isMute = true; //是否静音
				this.volume = 0; //声音大小：0-65535
				this.isRecord = false; //是否正在录像
				this.isShowTbr = false; //是否显示工具栏
				this.isShowDecrypt = false; //是否显示解密
				this.clipType = 0; //本地回放剪辑类型，0-sdv,1-mp4
			}
			return _ObsInfo;
		}());

		function _Video(owner, row, col, id) {
			//this.owner = owner;
			this.totalRow = row;
			this.totalCol = col;
			this.obsInfos = [];
			this.viewidx = 0;
			this.iLogonState = 0;//登录状态，0-未登录，1-正在登录，2-登录失败，3-登录成功
			this.self_id = owner;
			this.id = id;
			this.loginid = '';
			this.wTarget = false;
			this.hostName='';
			this.authName='';
			this.authPassword='';
			this.port='';
			this.bIsLogin= 0;
			for (var i = 0; i < this.totalCol * this.totalRow; i++) {
				this.obsInfos.push(new _ObsInfo(i));
			}
			this.obsInfos[0].viewState = 1;
		}
		return _Video;
	}())

	// ActiveX视频类
	var _VActiveX = (function(_this) {
		function _VActiveX(owner, row, col, id) {
			_this.call(this, owner, row, col, id);
			this.Connect();
		}

		_VActiveX.prototype.Login = function(hostName, authName, authPassword, port) {
			this.hostName=hostName;
			this.authName=authName;
			this.authPassword=authPassword;
			this.port=port;
			this.bIsLogin = 1;
						//this.Commander(NT.type.swallow_on_init.Entry_WorkMode, 1, '', '', '', '', '',0, 0, 0);	//设置Swallow工作模式为异步模式
			var r = this.Commander(NT.type.swallow_on_init.Login_Cmd, '', hostName, authName, authPassword, '', parseInt(port),0, 0, 0);
			if ((r != null) && (r.length > 0)) {
				this.iLogonState = 3;
				this.loginid = parseInt(r[0]);
			} else {
				this.iLogonState = 2;
				this.loginid = -1;
			}
			return this.loginid;
		};

		_VActiveX.prototype.Connect = function() {
			var ieVersion=window.navigator.platform;  
			//判断IE平台是32位还是64位
			if(ieVersion.indexOf('32')!=-1)
			{
				$('#' + this.self_id).prepend('<object id="' + this.id + '" name="' + this.id + '" classid="clsid:132E443B-E57A-4926-80B5-4BA9C37B4E9F"><param name="wmode" value="opaque"></object>');
			}
			else
			{
				//32位和64位使用同一个id
				$('#' + this.self_id).prepend('<object id="' + this.id + '" name="' + this.id + '" classid="clsid:132E443B-E57A-4926-80B5-4BA9C37B4E9F"><param name="wmode" value="opaque"></object>');
			}
			this.AttachEvents();
			$('#' + this.self_id).find('object').outerWidth(821).outerHeight($('#' + this.self_id).height());
		};

		_VActiveX.prototype.RegisterEvent = function(n, f) {
			var self = $('#' + this.self_id);
			eval('var o=self,_=arguments[1];(function(){function document.' + self[0].id + '_content::' + n + '(){_.apply(o,arguments);}})();');
		};

		_VActiveX.prototype.Commander_ = function(o, _IType, _vP1, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9) {
			try {
				var s = o.Commander(_IType, _vP1, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9);
				if (typeof(s) == 'string') {
					var a = s.split('\n');
					if ((a.length > 0) && ((a[0] == '0') || (a[0] == '-536739836') || a[0] == '-536870909')) {
						if (a[0] == '-536870909') {
							_App.ShowInfo(9099, true);
							return null;
						}
						if (a.length > 1) {
							return a[1].split(String.fromCharCode(8));
						} else {
							return a[0].split(String.fromCharCode(8));
						}
					} else {
						this.ShowError(_IType, s);
					}
				} else {
					this.ShowError(_IType, s);
				}
			} catch (e) {
				return null;
			}
			return null;
		};
		_VActiveX.prototype.Commander = function(_IType, _vP1, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9) {
			if (_vP1 === void 0) _vP1 = 0;
			if (_vP2 === void 0) _vP2 = 0;
			if (_vP3 === void 0) _vP3 = 0;
			if (_vP4 === void 0) _vP4 = 0;
			if (_vP5 === void 0) _vP5 = 0;
			if (_vP6 === void 0) _vP6 = 0;
			if (_vP7 === void 0) _vP7 = 0;
			if (_vP8 === void 0) _vP8 = 0;
			if (_vP9 === void 0) _vP9 = 0;
			var o = this.GetOleObject();
			if (!o){
				return null;
			}
			return this.Commander_(o, _IType, _vP1, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9);
		};

		_VActiveX.prototype.CommanderCurObs = function(_IType, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9) {
			if (_vP2 === void 0) _vP2 = 0;
			if (_vP3 === void 0) _vP3 = 0;
			if (_vP4 === void 0) _vP4 = 0;
			if (_vP5 === void 0) _vP5 = 0;
			if (_vP6 === void 0) _vP6 = 0;
			if (_vP7 === void 0) _vP7 = 0;
			if (_vP8 === void 0) _vP8 = 0;
			if (_vP9 === void 0) _vP9 = 0;
			var o = this.GetOleObject();
			if (!o){
				return null;
			}
			return this.Commander_(o, _IType, o.CurObs, _vP2, _vP3, _vP4, _vP5, _vP6, _vP7, _vP8, _vP9);
		};

		_VActiveX.prototype.AttachEvents = function() {
			var self = this;
			self.RegisterEvent('OnInit', function() {
				//重新获取窗体大小
				$('#' + self.self_id).find('object').outerWidth($('#' + self.self_id).width()).outerHeight($('#' + self.self_id).height());
				self.Commander(NT.type.swallow_on_init.Init_Cmd, self.totalCol, self.totalRow);
				var r = self.Commander(0x00020100);
				if (r != null) {
					self.obsId = parseInt(r[0]);
					//将每个窗体的obsId存入数组
					for(var i = 0; i < self.obsInfos.length; i++){
                        self.obsInfos[i].obsId = r[i];
					}
				}
				self.iLogonState = 1;
				self.downloadId = -1;
				self.clipId = 0;
				self.Commander(0x00010009, 2);
				if(self.bIsLogin)//判断当前为需要登录的状态
				{
					self.LogOff();
					//如果未登录再次登录
					if(self.hostName != '' && self.authName != '' && self.authPassword != '' && self.port != ''){
						self.Login(self.hostName, self.authName, self.authPassword, self.port);
					}
				}
			});
			
			self.RegisterEvent('LogonMsg', function(v1,v2) {
				if (self.loginid == v2) {
					if ( 1== v1) 
					{
						 //alert("logind:"+v2+" Login success");
					}	
					if ( 2== v1) 
					{
						 //alert("logind:"+v2+" Login timeout");
					}
					if ( 3== v1) 
					{
						 //alert("logind:"+v2+" Login failed");
					}
					if ( 4== v1) 
					{
						 //alert("logind:"+v2+" username err");
					}
					if ( 5== v1) 
					{
						 //alert("logind:"+v2+" password err");
					}
				}
               
            });

			// 以下为注册的swallow事件回调事件

			// 鼠标点击窗口回调方法
			self.RegisterEvent('OnObsClicked', function(v1) {
				var obsId = self.obsId;
				if (obsId !== v1) {
					self.obsId = v1;
				}
				for (var i = 0; i < self.obsInfos.length; i++) {
					if (v1 == self.obsInfos[i].obsId) {
						self.viewidx = i;
						//设置窗口对应通道号与音量值
						$('#live_channel_list').val(self.obsInfos[i].channelNo);
						$('#live_volume_progress').changewidth(parseInt(self.obsInfos[i].volume));
						if(true == self.obsInfos[i].isMute || 0 == self.obsInfos[i].playState){
							volume.changewidth(0);
							//将窗口对应音量图标置为关闭，音量条不允许滑动
							$('#live_volume').addClass('live_volume');	
						}else{
							//将窗口对应音量图标置为打开，音量条允许滑动
							$('#live_volume').removeClass('live_volume');
						}
						break;
					}
				}
				if(self.wTarget){
					var r = self.Commander(0x00020066, self.obsId);
				}
				if ((r != null) && (r.length == 2) && self.DoClick){
					var x = ((r[0] / 10000) * $('#' + self.self_id).width()).toFixed(1);
					var y = ((r[1] / 10000) * $('#' + self.self_id).height()).toFixed(1);
					var cShow = "(" + x + "," + y + ")";
					$('#live_position').val(cShow);
				}
				self.onObsClicked && self.onObsClicked(self, self.viewidx);
			});

			// 回放录像结束后的回调方法
			self.RegisterEvent('OnPlayBack', function(v1) {
				self.Commander(NT.type.swallow_live.Stop_Cmd, v1, 1);
			})

			// 下载前端文件开始后回调
			self.RegisterEvent('OnDownLoad', function(v1, v2) {
				if(v1 == self.downloadId)
				{
					if(0 == v2)
					{
						downloadstate = 0;
					}
					else
					{
						alert("Dwonload err");
					}
				}
			});

			// 查询远端前端录像文件后回调
			self.RegisterEvent('QueryResultJson', function(v1, v2) {
			//	var r = $.parseJSON(v2.split('\n')[1]).param;
			});

			// 远端视频剪辑回调
			self.RegisterEvent('OnVideoEdit', function() {
				stopShowClipProgress();
			});
			
			self.RegisterEvent('OnLastErrorInfo', function(_iEditID) {
				//权限不足时上抛消息id为0x8010（暂不使用）
				self.OnLastErrorInfo && self.OnLastErrorInfo(_iEditID);
			});
			
			// 全局异常捕获错误
			self.RegisterEvent('OnError', function(v1, v2) {
				
			});

			// 触发违法抓拍，上抛抓拍信息 
			this.RegisterEvent('OnITSPictureInfo', function(type, xml) {
                showCaptureInfo(xml)
            });
		};

		// 一些简单的dom事件操作方法注册
		_VActiveX.prototype.Ele = function(id) {
			return document.getElementById(id);
		};

		_VActiveX.prototype.DoClick = function() {
			this.wTarget = !this.wTarget;
		};

		_VActiveX.prototype.ShowError = function(cmd, error) {
			var s = typeof(error) == 'string' ? error : error.toString();
			//播放错误提示
			if(cmd.toString(16) == '20004' || cmd.toString(16) == '20065'){
            // alert('Playback failed, channel or stream does not exist');
			}
			console.log('Swallow.Commander(0x' + cmd.toString(16) + ') ERROR: ' + s);
		};

		_VActiveX.prototype.GetOleObject = function() {
			var o = this.Ele(this.id);
			if (o){
				return o.object;
			}
			return null;
		};

		_VActiveX.prototype.LogOff = function() {
			this.Commander(NT.type.swallow_on_init.Login_Off, this.loginid); // 注销登录
			NT.iLogonState = 0;
			this.bIsLogin = 0;
		};
		//重启设备
		_VActiveX.prototype.Reboot_Dev = function() {
			return this.Commander(NT.type.swallow_on_init.Reboot_Dev, this.loginid); 
		};

		// --------------------------预览界面命令码方法
		_VActiveX.prototype.ShowBitrate = function() {
			this.Commander(NT.type.swallow_live.ShowBitrate_Set, this.obsId, 1); // 显示帧率码率
		};
		
		_VActiveX.prototype.HideBitrate = function() {
			this.Commander(NT.type.swallow_live.ShowBitrate_Set, this.obsId, 0); // 隐藏帧率码率
		};

		/**
         * 播放实时视频
         * @method Play
         * @param v1：通道号，v2：码流号
		 * @return 通道总数
         */
		_VActiveX.prototype.Play = function(v1, v2) {
			return this.Commander(NT.type.swallow_live.StartRealTime_Cmd, this.obsId, this.loginid, parseInt(v1), parseInt(v2), 0, 0, 0, 0, 0); // 播放视频
		};

		_VActiveX.prototype.StopAll = function() {
			for(var x in this.obsInfos){
				this.Commander(NT.type.swallow_live.Stop_Cmd, parseInt(this.obsInfos[x].obsId), 1); // 停止播放
			}
		};

		_VActiveX.prototype.Stop = function() {
			return this.Commander(NT.type.swallow_live.Stop_Cmd, this.obsId, 1); // 停止播放
		};

		_VActiveX.prototype.SetFix = function() {
			return this.Commander(NT.type.swallow_live.VideoShowMode_Set, this.obsId, 1); // 视频显示模式，固定比例
		};
		
		_VActiveX.prototype.SetFit = function() {
			return this.Commander(NT.type.swallow_live.VideoShowMode_Set, this.obsId, 0); // 视频显示模式，适应窗口
		};
		
		_VActiveX.prototype.FullScreen = function() {
			return this.Commander(NT.type.swallow_on_init.FullScreen_Cmd); // 全屏播放
		};
			
		/**
         * 获取设备通道总数
         * @method GetChannelCount
         * @param 无
		 * @return 通道总数
         */
		_VActiveX.prototype.GetChannelCount = function() {
			var ret = this.Commander(NT.type.swallow_live.Dev_ChannelCount_Get, this.loginid);			
			return parseInt(ret);
		};

		/**
         * 电子放大
         * @method ZoomEnable
         * @param {int} v1 是否开启电子放大
         */
		_VActiveX.prototype.ZoomEnable = function(v1) {
			return this.Commander(NT.type.swallow_live.EZoomEnable_Set, this.obsId, v1);
		};

		/**
         * 前端对讲开启
         * @method TalkEnable
         * @param {int} v1 通道号
         */
		_VActiveX.prototype.TalkEnable = function(v1) {
			return this.Commander(NT.type.swallow_live.TalkEnable_Set, this.loginid, v1, 1);
		};

		/**
         * 前端对讲关闭
         * @method TalkDisable
         * @param {int} v1 通道号
         */
		_VActiveX.prototype.TalkDisable = function(v1) {
			return this.Commander(NT.type.swallow_live.TalkEnable_Set, this.loginid, v1, 0);
		};

		_VActiveX.prototype.MicEnable = function() {
			return this.Commander(NT.type.swallow_live.MicEnable_Set, this.loginid, 1); // 对讲开启
		};

		_VActiveX.prototype.MicStatus = function() {
			var r = this.Commander(NT.type.swallow_live.TalkStatus_Get, this.loginid); // 对讲状态
            if(r){
				return r[0];
			}else{
				return 3;
			}
		};

		_VActiveX.prototype.MicDisable = function() {
			return this.Commander(NT.type.swallow_live.MicEnable_Set, this.loginid, 0); // 对讲关闭
		};

		_VActiveX.prototype.SpeakerEnable = function() {
			return this.Commander(NT.type.swallow_live.SpeakerEnable_Set, this.obsId, 1); // 打开声音
		};

		_VActiveX.prototype.SpeakerDisable = function() {
			return this.Commander(NT.type.swallow_live.SpeakerEnable_Set, this.obsId, 0); // 关闭声音
		};

		_VActiveX.prototype.VolumeGet = function() {
			var r = this.Commander(NT.type.swallow_live.Volume_Get, this.obsId); // 获取音量大小
			if(r) {
				r[0] = (r[0] / 655).toFixed(0);
				return r[0];
			}else{
				return 'false';
			}
		};

		/**
         * 设置音量大小
         * @method VolumeSet
         * @param {int} v1 设置的音量大小
         */
		_VActiveX.prototype.VolumeSet = function(v1) {
			v1 = v1 * 655;
			var r = this.Commander(NT.type.swallow_live.Volume_Set, this.obsId, v1);
			return r;
		};

		/**
         * 设置码流
         * @method StreamSet
         * @param {int} v1 码流
		 * @param {int} v2 通道号
         */
		_VActiveX.prototype.StreamSet = function(v1, v2) {
			this.Commander(NT.type.swallow_live.StartRealTime_Cmd, this.obsId, this.loginid, v2, v1, 0, 0, 0, 0, 0); // 设置码流
		};

		/**
         * 视频解密
         * @method VideoDecode
         * @param {int} v1 视频解密密码
         */
		_VActiveX.prototype.VideoDecode = function(v1) {
			this.Commander(NT.type.swallow_live.Decrypt_SET, this.loginid, 0, v1);
		};

		/**
         * 检查系统版本
         * @method CheckSwallowVersion
         * @param {boolean} v1 
         */
		_VActiveX.prototype.CheckSwallowVersion = function(v1) {
			var r = this.Commander(NT.type.swallow_live.OcxVersion_check, v1); 
			if(r){
				return r[0];
			}
		};

		/**
         * 开始录像
         * @method RecStart
         * @param {String} v1 录像文件格式,0:sdv,1:mp4
         */
		_VActiveX.prototype.RecStart = function(m) {
			var value = '';
			var iValue = LOCAL_FILE_TYPE_SDV;
			if(m == 1){
				iValue = LOCAL_FILE_TYPE_MP4;
               value = '.mp4';
			}else{
               value = '.sdv';
			}
			var date = new Date();
			date = moment(date).format('YYYYMMDDHHmmss') + value;	
			var r = this.Commander(NT.type.swallow_live.BeginRec_Cmd, this.obsId, date, iValue);
			return r;
		};

		_VActiveX.prototype.RecStatus = function() {
			var r = this.Commander(NT.type.swallow_live.RecStatus_Get, this.obsId); // 录像状态
			if(r){
				return r[0];
			}
		};

		_VActiveX.prototype.RecStop = function() {
			var r = this.Commander(NT.type.swallow_live.EndRec_Cmd, this.obsId); // 结束录像
			return r;
		};

		/**
         * 抓拍照片
         * @method SnapShort
         * @param {String} m 抓拍得到图片格式
         */
		_VActiveX.prototype.SnapShot = function(m) {
			var value = '';
			if(m == 2){
                value = '.jpg';
			}else{
                value = '.bmp';
			}
			var date = new Date();
			date = moment(date).format('YYYYMMDDHHmmss') + value;
			var r = this.Commander(NT.type.swallow_live.Capture_Cmd, this.obsId, date);
			return r;
		};
		
		/**
         * 球机控制
         * @method PtzControl
         * @param {Number} v1:通道号，v2：控制码  v3：速度  v4:预置位编号，设置和调用预置位时使用，其余功能该参数无效
         */
		_VActiveX.prototype.PtzControl = function(v1,v2,v3,v4) {
			var r = this.Commander(NT.type.swallow_live.Dev_PTZ_Control, this.loginid,v1,v2,v3,v4);
		};
		
		/**
         * 球机控制 协议模式
         * @method PtzControlProtocol
         * @param {Number} v1:通道号，v2：控制码  v3：根据命令类型这两个参数的含义也不一样，水平速度或预置位号  v4: v5:控制类型,0，普通云台控制；1，电子云台e-PTZ.缺省为0
         */
		_VActiveX.prototype.PtzControlProtocol = function(v1,v2,v3,v4,v5) {
			return this.Commander(NT.type.swallow_live.Dev_Device_Ctrl, this.loginid,v1,v2, v3, v4, v5);
		};
		
		/**
         * 预置位添加
         * @method PresetAdd
         * @param {Number} v1预置位编号
         */
		_VActiveX.prototype.PresetAdd = function(v1,v2) {
			var r = this.Commander(NT.type.swallow_live.Dev_PTZ_Control, this.loginid, v1, TCC_SET_VIEW, 0, v2);
			return r;
		};
		
		/**
         * 预置位删除
         * @method PresetDelete
         * @param {Number} v1预置位编号
         */
		_VActiveX.prototype.PresetDelete = function(v1,v2) {
			var r = this.Commander(NT.type.swallow_live.Dev_PTZ_Control, this.loginid, v1, TCC_DELETE_VIEW, 0, v2);
			return r;
		};
		
		/**
         * 预置位调用
         * @method PresetCall
         * @param {Number} v1预置位编号
         */
		_VActiveX.prototype.PresetCall = function(v1,v2) {
			var r = this.Commander(NT.type.swallow_live.Dev_PTZ_Control, this.loginid, v1, TCC_CALL_VIEW, 0, v2);
			return r;
		};
		
		/**
         * 视频画线
         * @method DrawStart
         * @param {int} v1 画线类型
         */
		_VActiveX.prototype.DrawStart = function(v1) {
			return this.Commander(NT.type.swallow_live.StartDraw_Cmd, this.obsId, v1);
		};

		/**
         * 视频结束画线
         * @method DrawStop
         * @param {int} v1 画线类型
         */
		_VActiveX.prototype.DrawStop = function(v1) {
			return this.Commander(NT.type.swallow_live.StopDraw_Cmd, this.obsId, v1);
		};

		/**
         * 清除视频画线
         * @method DrawClear
         * @param {int} v1 画线类型
         */
		_VActiveX.prototype.DrawClear = function(v1) {
			return this.Commander(NT.type.swallow_live.ClearDraw_Cmd, this.obsId, v1);
		};

		/**
         * 获得画线信息
         * @method DrawInfoGet
         * @param {int} v1 画线类型
         */
		_VActiveX.prototype.DrawInfoGet = function(v1) {
			var r = this.CommanderCurObs(NT.type.swallow_live.GetDraw_Cmd, v1);
			if(r){
				return r[0];
			}
		};

		/**
         * 设置画线
         * @method DrawInfoSet
         * @param {String} v1 画线详细信息
		 * @param {int} v2 画线类型
         */
		_VActiveX.prototype.DrawInfoSet = function(v1, v2) {
			this.CommanderCurObs(NT.type.swallow_live.SetDraw_Cmd, v2, v1);
		};

		//------------------swallow录像回放模块----------------------

		/**
         * 回放本地录像文件
         * @method PlayBackByFileName
         * @param {String} fileName 本地录像文件名称
         */
		_VActiveX.prototype.PlayBackByFileName = function(fileName) {
			return this.Commander(NT.type.swallow_play_back.StartPlayBack_Cmd, this.obsId, this.loginid, 1, fileName);
		};

		/**
         * 按照时间段回放录像
         * @method PlayBackByTime
         * @param {String} startTime 开始时间
		 * @param {String} endTime 结束时间
		 * @param {int} channelNo 通道号
         */
		_VActiveX.prototype.PlayBackByTime = function(startTime, endTime, channelNo) {
			if (endTime === void 0) {
				endTime = new Date(startTime.valueOf() + 86400000 * 7);
			}
			channelNo = parseInt(channelNo);
			return this.Commander(StartPlayBackByTime_Cmd, this.obsId, this.loginid, 1, channelNo, 0, startTime, endTime);
		};

		/**
         * 按照时间段不同码流回放录像
         * @method PlayStreamSet
         * @param {String} startTime 开始时间
		 * @param {String} endTime 结束时间
		 * @param {int} channelNo 通道号
		 * @param {int} strameNo 码流
         */
		_VActiveX.prototype.PlayStreamSet = function(startTime, endTime, channelNo, strameNo) {
			if (endTime === void 0) {
				endTime = new Date(startTime.valueOf() + 86400000 * 7);
			}
			var r = this.Commander(NT.type.swallow_play_back.StartPlayBackByTime_Cmd, this.obsId, this.loginid, 1, channelNo, strameNo, moment(startTime).format('YYYYMMDDHHmmss'), moment(endTime).format('YYYYMMDDHHmmss')); // 按照时间段回放录像
		};

		_VActiveX.prototype.Pause = function() {
			return this.Commander(NT.type.swallow_play_back.PlayBackPause_Cmd, this.obsId, 1); // 回放录像暂停播放
		};
		_VActiveX.prototype.Locate = function(v1) {
			return this.Commander(NT.type.swallow_live.LocateEnable_Set, this.obsId, v1); // 3D Locate
		};

		_VActiveX.prototype.Resume = function() {
			return this.Commander(NT.type.swallow_play_back.PlayBackPause_Cmd, this.obsId, 0); // 回放录像继续播放
		};

		/**
         * 多窗口分割窗体对象
         * @method SplitScreen
         * @param {int} v1 窗口宽、v2窗口高
         */
		_VActiveX.prototype.SplitScreen = function(v1, v2) {
			return this.Commander(NT.type.swallow_on_init.Monopolize_Cmd, 0, v1, v2);	
		};

		/**
         * 录像加速(1~4级)
         * @method FastForword
         * @param {int} level 快进级别
         */
		_VActiveX.prototype.FastForword = function(level) {
			//获取当前速度，然后加以处理todo
			return this.Commander(NT.type.swallow_play_back.FastForward_Cmd, this.obsId, level); // 
		};
		
		/**
         * 录像减速(1~4级)
         * @method SlowForward
         * @param {int} level 慢进级别
         */
		_VActiveX.prototype.SlowForward = function(level) {
			//获取当前速度，然后加以处理todo
			return this.Commander(NT.type.swallow_play_back.SlowForward_Cmd, this.obsId, level);
		};

		_VActiveX.prototype.StepForward = function() {
			return this.Commander(NT.type.swallow_play_back.StepForward_Cmd, this.obsId); // 录像步进
		};

		_VActiveX.prototype.BrowseFolder = function() {
			var r = this.Commander(NT.type.swallow_on_init.SelectFileFolder); // 获取本地文件夹
			if (r) return r[0];
		};

		/**
         * 获取本地文件媒体文件
         * @method OpenFile
         * @param {String} v 存放本地文件文件夹名称
         */
		_VActiveX.prototype.OpenFile = function(v) {
			console.log(v)
			var r = this.Commander(NT.type.swallow_on_init.SelectFilePath, '.mp4\b.sdv', v);
			if(!r) {
				return;
			}
			return this.Commander(NT.type.swallow_play_back.StartPlayBack_Cmd, this.obsId, this.loginid, 0, r[0]);
		};

		_VActiveX.prototype.OpenPicture = function(v) {
			console.log(v)
			this.Commander(NT.type.swallow_on_init.OpenLocFileCmd, this.obsId, 1, v); // 获取本地文件图片
		};

		
		/**
         * 本地视频录像流媒体剪辑
         * @method LocalClip
         * @param {String} v1 生成的文件名称
		 * @param {String} v2 文件夹名称
		 * @param {int} v3 开始帧
		 * @param {int} v4 结束帧
         */
		_VActiveX.prototype.LocalClip = function(v1, v2, v3, v4) {
			var r = this.Commander(NT.type.swallow_play_back.Store_LocalEdit_Cmd, v1, v2, v3, v4); // 
			if (r[0] < 0) {
				playbackShowDialog(0);
			}
		};
		_VActiveX.prototype.GetClipMaxFrameNo = function() {
			var r = this.Commander(NT.type.swallow_play_back.LocalPlayingFrameNum_Max_Get, this.obsId); // 获取本地视频流媒体最大帧号
			if (!r) {
				playbackShowDialog(1);
			}
			if (r) return r;
		};

		_VActiveX.prototype.GetLocalClipProgress = function() {
			var r = this.Commander(NT.type.swallow_play_back.Store_LocalEditPos_Get, this.obsId); // 获取本地视频流媒体剪辑进度
			if (r) return parseInt(r[0]);
		};

		/**
         * 远程视频剪辑
         * @method OnClip
         * @param {String} fileName 文件名称
		 * @param {int} chanNo 通道号
		 * @param {int} streamNo 码流
		 * @param {String} startTime 开始时间
		 * @param {String} endTime 结束时间
         */
		_VActiveX.prototype.OnClip = function(fileName, chanNo, streamNo, startTime, endTime) {
			var r = this.Commander(NT.type.swallow_play_back.Store_RemoteEditStart_Cmd, this.loginid, fileName, chanNo, streamNo, startTime, endTime);
			if (r) {
				this.clipId = parseInt(r[0]);	
			}
		};

		_VActiveX.prototype.GetClipProgress = function() {
			var r = this.Commander(NT.type.swallow_play_back.Store_RemoteEditGetPos_Get, this.clipId); // 获取远程视频剪辑进度
			if (r) {
				return parseInt(r[0])
			}
		};

		_VActiveX.prototype.StopOnClip = function() {
			var r = this.Commander(NT.type.swallow_play_back.Store_RemoteEditStop_Cmd, this.clipId); // 停止远程视频剪辑
			if (r) {
				console.log(r)
			}
		};

		_VActiveX.prototype.GetPlayBackProgress = function() {
			var r = this.Commander(NT.type.swallow_play_back.Progress_Get, this.obsId); // 获取回放进度
			if (r) {
				return r[0];
			}
		};
		_VActiveX.prototype.SetPlayBackProgress = function(v1) {
			var r = this.Commander(NT.type.swallow_play_back.Obs_PlayBackSeek_Cmd, this.obsId, v1); // 设置回放进度
			if (r) {
				return r;
			}
		};

		/**
         * 查询远程文件
         * @method OnClip
         * @param {String} v1 开始时间
		 * @param {String} v2 结束时间
		 * @param {Number} v3 通道号
		 * @param {Number} v4 录像文件类型,0xFF-All, 1-手动, 2-定时, 3-报警
		 * @param {Number} v5 查询页码,从1开始
		 * @param {Number} v6 每页最大个数
         */
		_VActiveX.prototype.Query = function(v1, v2, v3, v4, v5, v6) {
			var chanNo = parseInt(v3);
			var startTime = v1;
			var stopTime = v2;
			var fileLocaTion = 1;//目标位置，0-本地，1-远程NVS
			var formatType = 1;	 //文件种类，0-所有文件，1-录像文件，2-图片
			var recType = parseInt(v4);	//录像文件类型,0xFF-All, 1-手动, 2-定时, 3-报警
			var pageCount = parseInt(v6);	//每页个数
			var pageNo = parseInt(v5) - 1;	//查询的页码
			var o = this.GetOleObject();
			if (!o) {
				return null;
			}
			var ret = o.Commander(Query_Cmd, this.loginid, chanNo, fileLocaTion, formatType, recType, startTime, stopTime, pageCount, pageNo);
			return ret.split('\n');
		};
		
		/**
         * 查询远程文件
         * @method QueryFileEx
		 * @param {Number} v1 通道号
		 * @param {Number} v2 码流号
         * @param {String} v3 开始时间
		 * @param {String} v4 结束时间		 
		 * @param {Number} v5 查询的页码
		 * @param {Number} v6 每页最大个数
		 * @retuen {String}查询到的文件结果
         */
		_VActiveX.prototype.QueryFileEx = function(v1, v2, v3, v4, v5, v6) {	
			var param = parseInt(v1);			//通道号
			param += '.' + parseInt(v2);		//码流号
			param += '.' + 1;		//目标位置，0-本地，1-远程NVS
			param += '.' + 1;		//文件种类，0-所有文件，1-录像文件，2-图片
			param += '.' + 0xFF;	//录像文件类型，0xFF-All, 1-手动, 2-定时, 3-报警	
			param += '.' + parseInt(v3);		//开始时间
			param += '.' + parseInt(v4);		//v结束时间
			param += '.' + 0xFF;	//录像文件类型，0xFF-All, 1-手动, 2-定时, 3-报警	
			param += '.' + parseInt(v6);		//每页文件个数
			param += '.' + parseInt(v5);		//查询的页码
			return this.Commander(Query_QueryEx_Cmd, this.loginid,strParam);			
		};

		/**
         * 下载远程文件到本地，同时只能下载1个文件
         * @method Download
         * @param {String} v1 远程文件名称
		 * @param {string} v2 下载成功保存本地文件名称
		 * @param {int} v3 文件保存的格式 0:sdv  1：mp4 
		 * @return {Number} 下载ID
         */
		_VActiveX.prototype.Download = function(v1, v2, v3) {
			if (this.downloadId >= 0) {
				return -1;
			}
			if(1 == v3)
			{
				v3 = LOCAL_FILE_TYPE_MP4;
			}
			
			var r = this.Commander(NT.type.swallow_play_back.DLStart_Cmd, this.loginid, v1, v2, 0, 0, v3);
			if (r) {
				this.downloadId = parseInt(r[0]);
				return this.downloadId;
			}
			return null;
		};

		/**
         * 按照时间段下载录像
         * @method DownloadByTime
		 * @param LocalFileName 保存文件名
		 * @param channelNo 通道号
		 * @param StreamNo 码流号
         * @param {String} startTime 开始时间
		 * @param {String} endTime 结束时间
		 * @param {String}SaveFileType //0:SDV, 1:MP4	
         */
		_VActiveX.prototype.DownloadByTime = function(LocalFileName,channelNo,StreamNo, startTime, endTime,SaveFileType) {
			if (this.downloadId >= 0) {
				return -1;
			}
			var FileType = LOCAL_FILE_TYPE_SDV;
			if(1 == SaveFileType)
			{
				FileType = LOCAL_FILE_TYPE_MP4;
			}
			var r = this.Commander(NT.type.swallow_play_back.DLStartByTime_Cmd, this.loginid, LocalFileName, channelNo, StreamNo, startTime, endTime, SaveFileType , 0, FileType);
			if (r) {
				this.downloadId = parseInt(r[0]);
				return this.downloadId;
			}
			return null;
		};
		
		/**
         * 停止下载文件到本地
         * @method StopDownload
         */
		_VActiveX.prototype.StopDownload = function() {
			if (-1 == this.downloadId) {
				return -1;
			}
			var r = this.Commander(NT.type.swallow_play_back.DLStop_Cmd, this.downloadId);
			this.downloadId = -1;
			return r;
		};

		/**
         * 获取下载进度
         * @method GetDownloadProgress
		 * @return {Number} 下载进度
         */
		_VActiveX.prototype.GetDownloadProgress = function() {
			if (-1 == this.downloadId) {
				return -1;
			}
			var r = this.Commander(NT.type.swallow_play_back.DLProgress_Get, this.downloadId); // 获取下载单一前端文件进度
			if (r) {
				return parseInt(r[0])
			}
			return null;
		};

		_VActiveX.prototype.GetTotalTime = function() {
			var r = this.Commander(NT.type.swallow_play_back.PlayBackTotalTime_Get, this.obsId); // 获取录像播放总时间
			if (r) {
				return parseInt(r[0])
			}
		};

		_VActiveX.prototype.GetNowTime = function() {
			var r = this.Commander(NT.type.swallow_play_back.PlayBackCurTime_Get, this.obsId); // 获取录像当前播放时间
			if (r) {
				return parseInt(r[0])
			}
		};

		_VActiveX.prototype.GetPlaybackState = function() {
			var r = this.Commander(NT.type.swallow_play_back.PlayStatus_Get, this.obsId); // 获取回放录像状态
			if (r) {
				console.log(r)
				return parseInt(r[0])
			}
		};

		// swallow配置页方法
		_VActiveX.prototype.LocalConfigGet = function(v1) {
			var r = this.Commander(NT.type.swallow_on_init.LocalConfigInfo_Get, v1);
			if(r){
				return r[0];
			}else{
				//alert("Operation Timeout");
			}
			
		};

		_VActiveX.prototype.LocalConfigSet = function(v1, m) {
			this.Commander(NT.type.swallow_on_init.LocalConfigInfo_Set, v1, m);
		}

		// 抓拍预览模块
		_VActiveX.prototype.StartPicStream = function(channelNo) { // channelNo 通道号
			var r = this.Commander(NT.type.swallow_play_back.Alarm_StartPicStream, this.loginid, channelNo); // 开启图片流
		}

		_VActiveX.prototype.StopPicStream = function(channelNo) { // channelNo 通道号
			var r = this.Commander(NT.type.swallow_play_back.StopPicStream, this.loginid, channelNo); // 关闭图片流
		}
		
		// swallow配置页方法
		/**
         * 设置数字通道参数
         * @method SetDigitalChannelConfig
          * @param {int} v1 通道号
         * @param {int} v2 前端设备类型，本质就是前端设备所采用的网络协议：0，私有协议（即Tiandy协议）；1，Onvif协议；3，rtsp
         * @param {string} v3 IP地址
         * @param {string} v4 用户名
         * @param {String} v5 密码
         * @param {int} v6 端口号
         * @param {String} v7 码流URL 例如“rtsp://1.2.3.4/1”
         */
		_VActiveX.prototype.SetDigitalChannelConfig = function(v1,v2,v3,v4,v5,v6,v7) { 
			var r = this.Commander(NT.type.swallow_on_init.SetDigitalChannelConfig, this.loginid, v1, v2, v3, v4, v5, v6, v7); //设置数字通道参数
		}
		
		/**
         *获取数字通道参数
         * @method GetDigitalChannelConfig
         * @param {int} v1 通道号
         */
		 _VActiveX.prototype.GetDigitalChannelConfig = function(v1) { 
			var r = this.Commander(NT.type.swallow_on_init.GetDigitalChannelConfig, this.loginid, v1); //获取数字通道参数
			if (null != r) {
				return r;
			}
		}
	
	
	// swallow配置页方法
		/**
         * 设置标题字符叠加
         * @method SetOsdTitle
         * @param {int} v1 通道号
         * @param {string} v2 设备标题（此参数针对不同设备有不同的长度限制，32字节、64字节、128字节。需要考虑字符截断的情况，请根据实际情况调用）
         * @param {int} v3 X坐标
         * @param {int} v4 Y坐标
         * @param {int} v5 设置标题的宏值  OSDTYPE_TITLE		0x02
         * @param {int} v6 使能
		 * @param {int} v7 要改变颜色的字符叠加类型  1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片  此处选择1
		 * @param {int} v8 颜色
         */
		_VActiveX.prototype.SetOsdTitle = function(v1,v2,v3,v4,v5,v6,v7,v8) { 
			var rosdtext = this.Commander(NT.type.swallow_on_init.SetOsdText, this.loginid, v1, v2); 
			var rosdtype = this.Commander(NT.type.swallow_on_init.SetOsdType, this.loginid, v1, v3, v4, v5, v6); 
			var rosdcolor = this.Commander(NT.type.swallow_on_init.SetOsdTypeColor, this.loginid, v1, v7, v8);
		}
		
		/**
         * 获取标题字符叠加
         * @method GetOsdTitle
         * @param {int} v1 通道号
         * @param {int} v2 设置标题的宏值  OSDTYPE_TITLE		0x02
		 * @param {int} v3 要改变颜色的字符叠加类型  1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片  此处选择1
      
         */
		_VActiveX.prototype.GetOsdTitle = function(v1,v2,v3) { 
			var r;
			var rosdtext = this.Commander(NT.type.swallow_on_init.GetOsdText, this.loginid, v1); 
			if(null != rosdtext) {
				r = rosdtext + ',';
			}
			var rosdtype = this.Commander(NT.type.swallow_on_init.GetOsdType, this.loginid, v1, v2);
			if(null != rosdtype) {
				r += rosdtype + ',';
			}
			var rosdcolor = this.Commander(NT.type.swallow_on_init.GetOsdTypeColor, this.loginid, v1, v3);
			if(null != rosdcolor) {
				r += rosdcolor;
			}
			return r.split(',');
		}
		
		
		/**
         * 设置日期时间字符叠加
         * @method SetOsdDate
         * @param {int} v1 通道号
         * @param {int} v2 X坐标
         * @param {int} v3 Y坐标
         * @param {int} v4 宏值  OSDTYPE_TIME		0x01 
         * @param {int} v5 使能
         * @param {int} v6 要改变颜色的字符叠加类型  1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片  此处选择2
         * @param {int} v7 颜色
         * @param {int} v8 是否显示星期
         * @param {int} v9  0- 24小时制  1-12小时制
		 * @param {int} v10 时间格式
         */
		_VActiveX.prototype.SetOsdDate = function(v1,v2,v3,v4,v5,v6,v7,v8,v9,v10) { 
			var rosdtype = this.Commander(NT.type.swallow_on_init.SetOsdType, this.loginid, v1, v2, v3, v4, v5); 
			var rosdcolor = this.Commander(NT.type.swallow_on_init.SetOsdTypeColor, this.loginid, v1, v6, v7);
			var rosddate = this.Commander(NT.type.swallow_on_init.SetOsdDateFormat, this.loginid, v1, v8, v9,v10); 
		}
		
		/**
         * 获取日期时间字符叠加
         * @method GetOsdDate
         * @param {int} v1 通道号
         * @param {int} v2 宏值  OSDTYPE_TIME		0x01 
         * @param {int} v3 要改变颜色的字符叠加类型  1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片  此处选择2
         */
		_VActiveX.prototype.GetOsdDate = function(v1,v2,v3) { 
			var r;
			var rosdtype = this.Commander(NT.type.swallow_on_init.GetOsdType, this.loginid, v1, v2); 
			if(null != rosdtype) {
				r = rosdtype + ',';
			}
			var rosdcolor = this.Commander(NT.type.swallow_on_init.GetOsdTypeColor, this.loginid, v1, v3);
			if(null != rosdcolor) {
				r += rosdcolor + ',';
			}
			var rosddate = this.Commander(NT.type.swallow_on_init.GetOsdDateFormat, this.loginid, v1); 
			if(null != rosddate) {
				r += rosddate;
			}
			return r.split(',');
		}

		
		/**
         * 设置附加字符
         * @method SetOsdAdditional
         * @param {int} v1 通道号
         * @param {int} v2 字符叠加区域编号
         * @param {int} v3 叠加颜色
         * @param {int} v4 X坐标
         * @param {int} v5 Y坐标
         * @param {string} v6 叠加内容
         */
		_VActiveX.prototype.SetOsdAdditional = function(v1,v2,v3,v4,v5,v6) { 
			var rosdtext = this.Commander(NT.type.swallow_on_init.SetOsdAdditional, this.loginid, v1, v2, v3, v4, v5, v6); 
		}
		
		/**
         * 设置叠加字符字体大小
         * @method SetOsdFontSize
         * @param {int} v1 通道号
         * @param {int} v2 osd类型1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片 7：人脸叠加OSD
         * @param {int} v3 字体大小，按位高16位宽，低16位高(24*24 = ) ,0-自适应
         */
		_VActiveX.prototype.SetOsdFontSize = function(v1,v2,v3) { 
			var FontSize = this.Commander(NT.type.swallow_on_init.SetOsdFontSize, this.loginid, v1, v2, v3); 
		}
		
		/**
         * 获取叠加字符字体大小
         * @method SetOsdFontSize
         * @param {int} v1 通道号
         * @param {int} v2 osd类型1：通道名称（文本） 2：时间日期 3:logo颜色 4：附加字符 5:交通专用 6：交通合成图片 7：人脸叠加OSD
         */
		_VActiveX.prototype.GetOsdFontSize = function(v1,v2) { 
			return this.Commander(NT.type.swallow_on_init.GetOsdFontSize, this.loginid, v1, v2); 
		}
		
		/**
         * 获取附加字符
         * @method GetOsdAdditional
         * @param {int} v1 通道号
		 * @param {int} v2 字符叠加区域编号
         */
		_VActiveX.prototype.GetOsdAdditional = function(v1,v2) { 
			var r = this.Commander(NT.type.swallow_on_init.GetOsdAdditional, this.loginid, v1, v2); 
			if(null != r) {
				return r;
			}
		}
	

		/* 设置视频分辨率
		* @method SetVideoSize
		* @param {int} v1 通道号
		* @param {int} v2 码流类型		 
		* @param {int} v3 分辨率
		*/
		_VActiveX.prototype.SetVideoSize = function(v1,v2,v3) { 
			var rvideosize = this.Commander(NT.type.swallow_on_init.SetVideoSize, this.loginid, v1, v2, v3); //设置视频分辨率
		}
		
		/* 设置视频码率
		* @method SetVideoByteRate
		* @param {int} v1 通道号
		* @param {int} v2 码流类型		 
		* @param {int} v3 码率
		*/
		_VActiveX.prototype.SetVideoByteRate = function(v1,v2,v3) { 
			var rbyterate = this.Commander(NT.type.swallow_on_init.SetMaxKByteRate, this.loginid, v1, v2, v3); //设置码率
		}
		
		/* 设置视频帧率
		* @method SetVideoFrameRate
		* @param {int} v1 通道号
		* @param {int} v2 码流类型		 
		* @param {int} v3 帧率
		*/
		
		_VActiveX.prototype.SetVideoFrameRate = function(v1,v2,v3) {
			var rframerate = this.Commander(NT.type.swallow_on_init.SetFrameRate, this.loginid, v1, v3, v2);	//设置帧率
		}
		
		/* 设置视频I帧帧率
		* @method SetVideoFrameRate
		* @param {int} v1 通道号
		* @param {int} v2 码流类型		 
		* @param {int} v3 I帧帧率
		*/
		_VActiveX.prototype.SetVideoIFrameRate = function(v1,v2,v3) {
			var riframerate = this.Commander(NT.type.swallow_on_init.SetIFrameRate, this.loginid, v1, v2, v3);// 设置I帧帧率
		}
		
		/* 设置视频I帧帧率
		* @method SetVideoVencType
		* @param {int} v1 通道号
		* @param {int} v2 码流类型		 
		* @param {int} v3 编码类型 0，H.264B；1，H.264M；2，H.264H；3，M-JPEG；4，MPEG4；5，H.265 
		*/
	    _VActiveX.prototype.SetVideoVencType = function(v1,v2,v3) {
			var rvenctype = this.Commander(NT.type.swallow_on_init.SetVencTypeEx, this.loginid, v1, v2, v3);//设置编码方式
		}	
		
		
		/**
         * 获取视频分辨率列表
         * @method GetVideoSizeList
         * @param {int} v1 通道号
         * @param {int} v2 码流类型
         */
		_VActiveX.prototype.GetVideoSizeList = function(v1,v2) { 
			var rvszlist = this.Commander(NT.type.swallow_on_init.GetVideoSzList, this.loginid, v1, v2);	//获取视频分辨率列表
			if(null != rvszlist) {
				return rvszlist;
			}
		}
		
		/**
		 * 获取视频当前分辨率
		 * @method GetVideoSize
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoSize = function(v1,v2) { 
			var rvideosize = this.Commander(NT.type.swallow_on_init.GetVideoSize, this.loginid, v1, v2);	//获取视频当前分辨率 
			if(null != rvideosize) {
				return rvideosize;
			}
		}
		
		/**
		 * 获取视频码率
		 * @method GetVideoByteRate
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoByteRate = function(v1,v2) { 
			var rbyterate = this.Commander(NT.type.swallow_on_init.GetMaxKByteRate, this.loginid, v1, v2);	//获取码率 
			if(null != rbyterate) {
				return rbyterate;
			}
		}
		
		/**
		 * 获取视频帧率列表
		 * @method GetVideoFrameList
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoFrameList = function(v1,v2) { 
			var rframelist = this.Commander(NT.type.swallow_on_init.GetFrameList, this.loginid, v1);
			if(null != rframelist) {
				return rframelist;
			}
		}
		
		/**
		 * 获取视频当前帧率
		 * @method GetVideoFrameRate
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoFrameRate = function(v1,v2) { 
			var rframerate = this.Commander(NT.type.swallow_on_init.GetFrameRate, this.loginid, v1, v2);	//获取帧率
			if(null != rframerate) {
				return rframerate;
			}
		}
		
		/**
		 * 获取视频I帧帧率
		 * @method GetVideoIFrameRate
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoIFrameRate = function(v1,v2) { 
			var riframerate = this.Commander(NT.type.swallow_on_init.GetIFrameRate, this.loginid, v1, v2); 	//获取I帧帧率
			if(null != riframerate) {
				return riframerate;
			}	
		}
		
		/**
		 * 获取视频编码列表
		 * @method GetVideoEncodeList
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoEncodeList = function(v1,v2) { 
			var renclist = this.Commander(NT.type.swallow_on_init.GetEncodeList, this.loginid, v1, v2);		//获取编码列表
			if(null != renclist) {
				return renclist;
			}
		}
		
		/**
		 * 获取视频当前编码方式
		 * @method GetVideoVencType
		 * @param {int} v1 通道号
		 * @param {int} v2 码流类型
		 */
		_VActiveX.prototype.GetVideoVencType = function(v1,v2) { 
			var rvenctype = this.Commander(NT.type.swallow_on_init.GetVencTypeEx, this.loginid, v1, v2); 	//获取编码方式
			if(null != rvenctype) {
				return rvenctype;
			}
		}
		
		/**
		 * 设置通道类型
		 * @method SetChannelType
		 * @param {int} v1 通道号
		 * @param {int} v2 通道类型
		 */
		_VActiveX.prototype.SetChannelType = function(v1,v2) { 
			var rchantype = this.Commander(NT.type.swallow_on_init.SetChannelProperty, this.loginid, v1, v2); 
		}
			
		/**
		 * 获取通道类型
		 * @method GetChannelType
		 * @param {int} v1 通道号
		 */
		_VActiveX.prototype.GetChannelType = function(v1) { 
			var rchantype = this.Commander(NT.type.swallow_on_init.GetChannelProperty, this.loginid, v1);
			 if(null != rchantype){
				 return rchantype;
			 }
		}
		
		/**
		 * Get Factory ID
		 * @method GetFactoryID
		 */
		_VActiveX.prototype.GetFactoryID = function() { 
			return this.Commander(NT.type.swallow_on_init.GetFactoryID, this.loginid);
		}
		
		/**
		 * Get Version Information
		 * @method GetVersionInfo
		 */
		_VActiveX.prototype.GetVersionInfo = function() { 
			return this.Commander(NT.type.swallow_on_init.GetVersionInfo, this.loginid);
		}
		
		
		/**
		 * Get NVS Address
		 * @method GetNVSAddr
		 */
		_VActiveX.prototype.GetNVSAddr = function() { 
			return this.Commander(NT.type.swallow_on_init.GetNVSAddr, this.loginid);
		}
		
		/**
		 * Set Device Name
		 * @method SetDevName
		 * v1 Channel Number, Nvr = 0x7fffffff
		 * v2 Device Name 
		 */
		_VActiveX.prototype.SetDevName = function(v1, v2) { 
			return this.Commander(NT.type.swallow_on_init.SetDevName, this.loginid, v1, v2);
		}
		
		/**
		 * Get Device Name
		 * @method GetDevName
		 * v1 Channel Number, Nvr = 0x7fffffff
		 */
		_VActiveX.prototype.GetDevName = function(v1) { 
			return this.Commander(NT.type.swallow_on_init.GetDevName, this.loginid, v1);
		}
		
		/**
		 * Set Device Mode
		 * @method SetDevMode
		 * v1 Channel Number
		 * v2 Device Mode 
		 */
		_VActiveX.prototype.SetDevMode = function(v1, v2) { 
			return this.Commander(NT.type.swallow_on_init.SetDevMode, this.loginid, v1, v2);
		}
		
		/**
		 * Get Device Mode
		 * @method GetDevMode
		 * v1 Channel Number
		 */
		_VActiveX.prototype.GetDevMode = function(v1) { 
			return this.Commander(NT.type.swallow_on_init.GetDevMode, this.loginid, v1);
		}
		
		return _VActiveX;
	}(_Video))

	NT._VActiveX = _VActiveX;
}(NT))
